/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.database.jdbc.graph;

import java.text.NumberFormat;
import jclass.chart.ChartDataView;
import jclass.chart.ChartDataViewSeries;
import jclass.chart.EventTrigger;
import jclass.chart.JCAxis;
import jclass.chart.JCChart;
import jclass.chart.JCChartLabel;
import jclass.chart.JCChartStyle;
import jclass.chart.JCDataIndex;
import jclass.chart.JCPickEvent;
import jclass.chart.JCPickListener;
import jclass.chart.Timer;
import jclass.chart.TimerListener;
import jclass.chart.VectorDataSource;

public class DbJdbcPointGraph
extends JCChart
implements JCPickListener,
TimerListener {
    protected JCChartLabel chartLabel;
    protected Timer timer;
    private static NumberFormat nf = NumberFormat.getInstance();

    public DbJdbcPointGraph(String string) {
        super(11);
        nf.setMaximumFractionDigits(4);
        this.getHeader().setIsShowing(true);
        this.setTitle(string);
        this.setTrigger(0, new EventTrigger(0, 1));
        this.setTrigger(1, new EventTrigger(1, 2));
        this.setTrigger(2, new EventTrigger(2, 4));
        this.getChartArea().setElevation(30);
        this.getChartArea().setDepth(20);
        this.getChartArea().setRotation(20);
        this.getChartArea().setFastAction(true);
        this.createChartLabel();
    }

    public void setTitle(String string) {
        this.getHeader().getLabel().setText(string);
    }

    public void setInput(double[][] dArray, JCChartStyle[] jCChartStyleArray) {
        ChartDataView chartDataView = this.getDataView(0);
        VectorDataSource vectorDataSource = new VectorDataSource(dArray);
        chartDataView.setDataSource(vectorDataSource);
        chartDataView.setChartStyle(jCChartStyleArray);
        this.reset();
        chartDataView.setChanged(true, 2);
    }

    protected void createChartLabel() {
        this.chartLabel = new JCChartLabel("", false);
        this.chartLabel.setAnchor(10);
        this.chartLabel.setAttachMethod(3);
        this.chartLabel.setBorderType(1);
        this.chartLabel.setBorderWidth(2);
        this.chartLabel.hide();
        this.addPickListener(this);
        this.addChartLabel(this.chartLabel);
    }

    public void pick(JCPickEvent jCPickEvent) {
        double d = 0.0;
        JCDataIndex jCDataIndex = jCPickEvent.getPickResult();
        if (jCDataIndex != null && jCDataIndex.getDistance() <= 5) {
            double d2 = jCDataIndex.getDataView().getSeries(jCDataIndex.getSeriesIndex()).getY(jCDataIndex.getPoint());
            ChartDataViewSeries[] chartDataViewSeriesArray = jCDataIndex.getDataView().getSeries();
            int n = 0;
            while (n < chartDataViewSeriesArray.length) {
                d += chartDataViewSeriesArray[n].getY(0);
                ++n;
            }
            double d3 = d2 / d * 100.0;
            String string = String.valueOf(nf.format(d2)) + "[NEWLINE]" + nf.format(d3) + "%";
            this.chartLabel.setDataIndex(jCDataIndex);
            this.chartLabel.setText(string);
            this.chartLabel.show();
            if (this.timer == null) {
                this.timer = new Timer(1000);
                this.timer.addTimerListener(this);
            }
            this.timer.setTime(1500);
        }
    }

    public void timerExpired(Timer timer) {
        if (this.chartLabel != null) {
            this.chartLabel.hide();
        }
    }

    public void zoom(double d, double d2, JCAxis jCAxis, boolean bl) {
        boolean bl2 = false;
        ChartDataView chartDataView = this.getDataView(0);
        if (chartDataView != null) {
            JCAxis jCAxis2 = chartDataView.getXAxis();
            JCAxis jCAxis3 = chartDataView.getYAxis();
            if (jCAxis == jCAxis2) {
                if (Math.abs(d2 - d) >= 1.0) {
                    bl2 = true;
                }
            } else if (jCAxis == jCAxis3 && Math.abs(d2 - d) >= 0.001) {
                bl2 = true;
            }
        }
        if (bl2) {
            super.zoom(d, d2, jCAxis, bl);
        }
    }
}

